/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.controllers;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import noppes.npcs.LogWriter;
import noppes.npcs.api.mixin.client.audio.IPositionedSoundMixin;
import noppes.npcs.api.mixin.client.audio.ISoundHandlerMixin;
import noppes.npcs.api.mixin.client.audio.ISoundManagerMixin;
import noppes.npcs.api.mixin.client.audio.ISoundSystemMixin;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.util.MusicData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobBard;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.Source;

public class MusicController {
    public static MusicController Instance;
    public String music = "";
    public String song = "";
    public EntityNPCInterface musicBard = null;
    public EntityNPCInterface songBard = null;
    public boolean unloadMusicBard = false;
    public boolean unloadSongBard = false;

    public MusicController() {
        Instance = this;
    }

    public void bardPlaySound(String song, boolean isStreamer, EntityNPCInterface npc) {
        this.stopSound(song, isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC);
        ISound.AttenuationType aType = ISound.AttenuationType.LINEAR;
        ResourceLocation res = new ResourceLocation(song);
        float x = (float)npc.field_70165_t;
        float y = (float)npc.field_70163_u;
        float z = (float)npc.field_70161_v;
        if (isStreamer) {
            this.song = song;
            this.songBard = npc;
        } else {
            this.music = song;
            this.musicBard = npc;
            aType = ISound.AttenuationType.NONE;
            x = 0.0f;
            y = 0.0f;
            z = 0.0f;
            for (MusicData md : ClientTickHandler.musics.values()) {
                if (md.name.isEmpty() || md.name.indexOf("minecraft") != 0) continue;
                Minecraft.func_71410_x().func_147118_V().func_189520_a(md.name, SoundCategory.MUSIC);
            }
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(res, isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC, 1.0f, 1.0f, false, 0, aType, x, y, z));
    }

    public void checkBards(EntityPlayer player) {
        int zD;
        int yD;
        int xD;
        int z;
        int y;
        int x;
        JobBard job;
        Entity entity;
        if (this.music.isEmpty()) {
            if (this.musicBard != null) {
                this.musicBard = null;
            }
        } else if (this.musicBard == null || !(this.musicBard.advanced.jobInterface instanceof JobBard)) {
            this.stopSound(this.music, SoundCategory.MUSIC);
        } else {
            entity = player.field_70170_p.func_73045_a(this.musicBard.func_145782_y());
            if (entity == null) {
                this.unloadMusicBard = true;
                job = (JobBard)this.musicBard.advanced.jobInterface;
                if (job.hasOffRange) {
                    x = job.range[1];
                    y = job.range[1];
                    z = job.range[1];
                    if (!job.isRange) {
                        x = job.maxPos[0];
                        y = job.maxPos[1];
                        z = job.maxPos[2];
                    }
                    xD = (int)Math.abs(player.field_70165_t - this.musicBard.field_70165_t);
                    yD = (int)Math.abs(player.field_70163_u - this.musicBard.field_70163_u);
                    zD = (int)Math.abs(player.field_70161_v - this.musicBard.field_70161_v);
                    if (xD > x || yD > y || zD > z) {
                        this.stopSound(this.song, SoundCategory.MUSIC);
                    }
                }
            }
        }
        if (this.song.isEmpty()) {
            if (this.songBard != null) {
                this.songBard = null;
            }
        } else if (this.songBard == null || !(this.songBard.advanced.jobInterface instanceof JobBard)) {
            this.stopSound(this.song, SoundCategory.AMBIENT);
        } else {
            entity = player.field_70170_p.func_73045_a(this.songBard.func_145782_y());
            if (entity == null) {
                this.unloadSongBard = true;
                job = (JobBard)this.songBard.advanced.jobInterface;
                if (job != null && job.hasOffRange) {
                    x = job.range[1];
                    y = job.range[1];
                    z = job.range[1];
                    if (!job.isRange) {
                        x = job.maxPos[0];
                        y = job.maxPos[1];
                        z = job.maxPos[2];
                    }
                    xD = (int)Math.abs(player.field_70165_t - this.songBard.field_70165_t);
                    yD = (int)Math.abs(player.field_70163_u - this.songBard.field_70163_u);
                    zD = (int)Math.abs(player.field_70161_v - this.songBard.field_70161_v);
                    if (xD > x || yD > y || zD > z) {
                        this.stopSound(this.song, SoundCategory.AMBIENT);
                    }
                }
            }
        }
    }

    public void forcePlaySound(SoundCategory cat, String sound, float x, float y, float z, float volume, float pitch) {
        if (cat == null || sound == null || sound.isEmpty()) {
            return;
        }
        ISound.AttenuationType aType = ISound.AttenuationType.LINEAR;
        Minecraft mc = Minecraft.func_71410_x();
        if (cat == SoundCategory.MUSIC) {
            Minecraft.func_71410_x().func_147118_V().func_189520_a("", SoundCategory.MUSIC);
            aType = ISound.AttenuationType.NONE;
            x = mc.field_71439_g != null ? (float)mc.field_71439_g.field_70165_t : 0.0f;
            y = mc.field_71439_g != null ? (float)mc.field_71439_g.field_70163_u + 0.5f : 0.0f;
            z = mc.field_71439_g != null ? (float)mc.field_71439_g.field_70161_v : 0.0f;
        }
        mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(sound), cat, volume, pitch, false, 0, aType, x, y, z));
    }

    public boolean isBardPlaying(String song, boolean isStreamer) {
        return this.isPlaying(song) || (isStreamer ? !song.isEmpty() && this.isPlaying(this.song) : !this.music.isEmpty() && this.isPlaying(this.music));
    }

    public boolean isPlaying(String music) {
        if (music == null || music.isEmpty()) {
            return false;
        }
        ResourceLocation resource = new ResourceLocation(music);
        SoundManager sm = ((ISoundHandlerMixin)Minecraft.func_71410_x().func_147118_V()).npcs$getSndManager();
        Map<String, ISound> playingSounds = ((ISoundManagerMixin)sm).npcs$getPlayingSounds();
        if (playingSounds == null) {
            return false;
        }
        for (ISound sound : playingSounds.values()) {
            if (!sound.func_184364_b().func_188719_a().equals((Object)resource) && !sound.func_147650_b().equals((Object)resource)) continue;
            return true;
        }
        return false;
    }

    public void playSound(SoundCategory category, String music, float x, float y, float z, float volume, float pitch) {
        if (this.isPlaying(music)) {
            return;
        }
        ISound.AttenuationType aType = ISound.AttenuationType.LINEAR;
        ResourceLocation res = new ResourceLocation(music);
        if (category == SoundCategory.MUSIC) {
            aType = ISound.AttenuationType.NONE;
            x = 0.0f;
            y = 0.0f;
            z = 0.0f;
        }
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(res, category, volume, pitch, false, 0, aType, x, y, z));
    }

    public void setNewPosSong(String song, float x, float y, float z) {
        if (song == null || song.isEmpty()) {
            return;
        }
        ResourceLocation resource = new ResourceLocation(song);
        SoundManager sm = ((ISoundHandlerMixin)Minecraft.func_71410_x().func_147118_V()).npcs$getSndManager();
        Map<String, ISound> playingSounds = ((ISoundManagerMixin)sm).npcs$getPlayingSounds();
        if (playingSounds == null) {
            return;
        }
        String uuid = null;
        for (String string : playingSounds.keySet()) {
            ISound sound = playingSounds.get(string);
            if (!sound.func_184364_b().func_188719_a().equals((Object)resource) && (!sound.func_147650_b().equals((Object)resource) || !(sound instanceof PositionedSound))) continue;
            ((IPositionedSoundMixin)sound).npcs$setXPosF(x);
            ((IPositionedSoundMixin)sound).npcs$setYPosF(y);
            ((IPositionedSoundMixin)sound).npcs$setZPosF(z);
            uuid = string;
            break;
        }
        System.out.println("New pos song uuid: \"" + uuid + "\" to [" + (int)x + ", " + (int)y + ", " + (int)z + "]");
        if (uuid != null) {
            SoundSystem sndSystem = null;
            for (Field f : sm.getClass().getDeclaredFields()) {
                if (!f.getType().getName().contains("SoundSystem")) continue;
                try {
                    f.setAccessible(true);
                    sndSystem = (SoundSystem)f.get(sm);
                }
                catch (IllegalAccessException e) {
                    LogWriter.debug(e.toString());
                }
                break;
            }
            if (sndSystem == null) {
                return;
            }
            Library library = ((ISoundSystemMixin)sndSystem).npcs$getSoundLibrary();
            if (library == null) {
                return;
            }
            Source source = (Source)library.getSources().get(uuid);
            if (source != null && source.position != null) {
                source.position.x = x;
                source.position.y = y;
                source.position.z = z;
            }
        }
    }

    public void stopSound(String song, SoundCategory category) {
        if (song == null) {
            song = "";
        }
        Minecraft.func_71410_x().func_147118_V().func_189520_a(song, category);
        if (category == SoundCategory.AMBIENT) {
            this.song = "";
            this.songBard = null;
        } else if (category == SoundCategory.MUSIC) {
            this.music = "";
            this.musicBard = null;
        }
    }

    public void stopSounds() {
        Minecraft.func_71410_x().func_147118_V().func_147690_c();
        this.song = "";
        this.songBard = null;
        this.music = "";
        this.musicBard = null;
    }
}

